<?php
class Produkty
{
	const PRODUCTSCATEGORYID = '14';
	const tabela = 'products';

	private $_lista = array();
	private $db;
	public $_kategorie = array();

	public $PagesNum = 0;

	public $products;

	public function __construct()
	{
		$this->db = Zend_Registry::get('db');
	}

	public function getIdents($name){
		try
		{
			if(empty($name))
			{
				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora CELI.');
			}

			$sql = 'select '.$name.' as name from '.Index::dbPrefiks.self::tabela.' where kategoria = 43 GROUP BY '.$name.' ORDER BY '.$name.' ASC';
			return $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function pagining($items,$page,$limit){
		$pg = 1;
		$fl = 0;
		if(is_array($items)){
			foreach ($items as $key => $i){
				$fl++;
				if($fl > $limit){
					$pg++;
					$fl = 0;
				}
				$products[$pg][] = $i;
			}
			if(isset($products)){
				$this->PagesNum = count($products);
				return $products[$page];
			}
			else
			return false;
		}

		return false;
	}

	public function getProducts($page = 1,$limit = 10){
		return $this->pagining($this->products,$page,$limit);
	}

	public function search_products($cat=0,$search=array()){
		try
		{
			$sql = 'select * from '.Index::dbPrefiks.self::tabela.' WHERE id > 0';
			if($cat > 0){
				$sql .= ' AND kategoria = '.$cat;
			}

			if(!empty($search['producents'])){
				$sql .= " AND marka = '".$search['producents']."'";
			}
			if(!empty($search['sessons'])){
				$sql .= " AND sezon = '".$search['sessons']."'";
			}
			if(!empty($search['types'])){
				$sql .= " AND rodzaj = '".$search['types']."'";
			}
			if(!empty($search['sizes'])){
				$sql .= " AND rozmiar = '".$search['sizes']."'";
			}

			$sql .= ' ORDER BY kolejnosc ASC';

			$this->products = $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	private function getPromotionsList($id)
	{
		try
		{

			if(empty($id))
			{
				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
			}

			$sql = 'select * from '.Index::dbPrefiks.'promotion where kategoria='.(int)$id;

			return $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getProductFiles($id)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
			}

			$sql = 'select * from '.Index::dbPrefiks.'files where product='.(int)$id.' order by kolejnosc ASC';

			return $this->db->fetchAll($sql);

		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getProductId($id)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
			}

			$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where id='.(int)$id;
			$product = $this->db->fetchRow($sql);
			$product['files'] = $this->getProductFiles($id);

			return $product;

		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getProductsAll()
	{
		try
		{
			$sql = 'select * from '.Index::dbPrefiks.self::tabela.' order by kolejnosc asc';

			return $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getProduct($id,$limit=0)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
			}

			$sql = 'select * from '.Index::dbPrefiks.self::tabela;
			
			if($id > 0){
				$sql .= ' where kategoria='.(int)$id;
			}
			
			$sql .= ' order by kolejnosc ASC';

			if($limit > 0){
				$sql.= ' limit '.$limit;
			}
			
			$this->products =  $this->db->fetchAll($sql);
			
			foreach ($this->products as &$p){
				$files = $this->getProductFiles($p['id']);
				if(count($files) > 0)
				$p['files'] = $files;
				else 
				$p['files'] = 'no';
				unset($files);
			}
			
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getProductsList()
	{
		try
		{
			$sql = 'select p.*, (select nazwa from cms_obrazki where kategoria=p.id and tytulowe=1 LIMIT 1) zdjecie from '.Index::dbPrefiks.self::tabela.' p  order by kolejnosc asc';
			//print_r($sql);
			return  $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getPhotos($kategoria=null,$limit=0,$co='produkt')
	{
		try
		{
			if(!empty($kategoria))
			{
				$sql = "select nazwa from cms_obrazki where kategoria=".$kategoria." and co='".$co."' order by id ASC";
				if($limit > 0){
					$sql .= ' limit '.$limit;
				}
			}
			if($limit == 1)
			$return = $this->db->fetchRow($sql);
			else
			$return = $this->db->fetchAll($sql);
			return $return;

		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
}
?>