<?php
session_start();

define ('PREFIKS', 'cms_');
class Index
{
	const dbPrefiks = PREFIKS;

	public function __construct()
	{
		/*
		* bootstrap
		*/

		session_cache_limiter("private_no_expire");

		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Content-Type: text/html; charset=utf-8;");

		error_reporting(E_ALL);

		date_default_timezone_set('Europe/Warsaw');

		set_include_path('.' . PATH_SEPARATOR . 'cms/library' . PATH_SEPARATOR . get_include_path());
		set_include_path('.' . PATH_SEPARATOR . 'php/modules' . PATH_SEPARATOR . get_include_path());

		include "Zend/Loader.php";
		Zend_Loader::registerAutoload();

		$config = new Zend_Config_Ini ('./cms/config/config.ini', 'glowne');
		$configBaza = new Zend_Config_Ini ('./cms/config/config.ini', 'baza');
		$registry = Zend_Registry::getInstance();


		$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
		Zend_Db_Table::setDefaultAdapter($db);

		$db->query('SET NAMES utf8');

		$registry->set('db', $db);
		$registry->set('config', $config);
		$registry->set('configBaza', $configBaza);

		include_once('Smarty/Smarty.class.php');

		$tpl = new Smarty;
		$tpl->template_dir = './templates/';
		$tpl->compile_dir = './templates_c/';

		$tpl->register_modifier('ss', 'stripslashes');
		$tpl->register_modifier('url', 'Index::toPermalink');

		$registry->set('tpl', $tpl);

		$this->getContent();
	}

	public static function przechwyc_blad($e)
	{
		$smarty = Zend_Registry::get('tpl');

		$smarty->assign('nr',$e->getCode());
		$smarty->assign('msg',$e->getMessage());

		echo $e->getMessage();
	}

	function randomString($length){
		static $srand;
		$result = '';
		if($srand != true){
			$srand = true;
			srand((double)microtime()*1000000);
		}
		$chars = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		for($i=0; $i<$length; $i++){
			$result .= substr($chars,rand(0,strlen($chars)-1),1);
		}
		return $result;
	}


	private function authentication($login,$password) {
		$filtr = new Zend_Filter_StripTags();
		$login = $filtr->filter($login);
		$password = md5($filtr->filter($password));
		$db = Zend_Registry::get('db');
		$I = $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."users WHERE nazwa = '$login' AND haslo='$password'");

		if(!empty($I)){
			$_SESSION['user'] = $I;
			return true;
		}
		else {
			return false;
		}
	}

	private function check_mail_syntax($email)
	{
		$to_work_out = explode("@", $email);
		if (!isset($to_work_out[0])) return FALSE;
		if (!isset($to_work_out[1])) return FALSE;

		$pattern_local =  '^([0-9a-z]*([-|_]?[0-9a-z]+)*)(([-|_]?)\.([-|_]?)[0-9a-z]*([-|_]?[0-9a-z]+)+)*([-|_]?)$';
		$pattern_domain = '^([0-9a-z]+([-]?[0-9a-z]+)*)(([-]?)\.([-]?)[0-9a-z]*([-]?[0-9a-z]+)+)*\.[a-z]{2,4}$';
		$match_local = eregi($pattern_local, $to_work_out[0]);
		$match_domain = eregi($pattern_domain, $to_work_out[1]);

		if ($match_local && $match_domain) {
			return TRUE;
		}
		return FALSE;
	}

	private function checkEmpty($string){
		$string = str_replace(' ','',$string);
		$string = strip_tags($string);
		if(strlen($string) > 0)
		return false;
		return true;
	}

	private function registration($data){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');
		$err = 0;
		$filtr 				= 	new Zend_Filter_StripTags();
		$dane['nazwa'] 	 	= 	$filtr->filter($data['_login']);
		$dane['imie']	 	= 	$filtr->filter($data['_name']);
		$dane['nazwisko'] 	=   $filtr->filter($data['_surname']);
		$dane['e-mail']		=	$filtr->filter($data['_email']);
		$dane['rola']		=	'user';
		$dane['type']		=	2;

		if(!$this->checkEmpty($dane['nazwa']) && !$this->checkEmpty($dane['e-mail'])){
			if($this->check_mail_syntax($dane['e-mail'])){
				$I = $db->fetchRow("SELECT id FROM ".Index::dbPrefiks."users WHERE `nazwa` = '".$dane['nazwa']."' or `e-mail` = '".$dane['e-mail']."'");
				if((int)$I['id'] > 0){
					$tpl->assign('err',3);
					$err = 1;
				}
				else {
					$password = $this->randomString(8);

					$smarty = new Smarty;
					$smarty->compile_check = true;
					$smarty->debugging = false;
					$smarty->assign('dane',$dane);
					$smarty->assign('password',$password);
					$body = $smarty->fetch('reg_email.tpl');

					$dane['haslo'] =md5($password);

					$mail = new Zend_Mail('iso-8859-2');
					$mail->setBodyHtml($body);
					$mail->setFrom('rejestracja@marsel.pl', 'Marsel');
					$mail->addTo($dane['e-mail'], $dane['nazwa']);
					$mail->setSubject('Rejestracja Marsel');
					if($mail->send()){
						$tpl->assign('reg_ok',1);
						$db->insert(Index::dbPrefiks.'users',$dane);
					}
					else {
						$tpl->assign('err',4);
						$err = 1;
					}
				}
			}
			else {
				$tpl->assign('err',2);
				$err = 1;
			}
		}
		else{
			$tpl->assign('err',1);
			$err = 1;
		}
		$tpl->assign('error',$err);

	}

	private function newsletter($email){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		$filtr 				= 	new Zend_Filter_StripTags();
		$email = $filtr->filter($email);

		$I = $db->fetchRow("
		SELECT count(*) AS num 
		FROM ".Index::dbPrefiks."newsletter_users 
		WHERE `e-mail` = '$email'");

		switch($I['num']){
			case 1:
				$db->delete(Index::dbPrefiks.'newsletter_users',"`e-mail`='".$email."'");
				$tpl->assign('let_ok',2);
				break;
			default:
				if($this->check_mail_syntax($email)){
					$data['e-mail'] = $email;
					$data['date'] = time();
					$db->insert(Index::dbPrefiks.'newsletter_users', $data);
					$tpl->assign('let_ok',1);
				}
				else {
					$tpl->assign('let_error',1);
				}
				break;
		}
	}

	function send_question(){
		
		$filtr 				= 	new Zend_Filter_StripTags();

		$dane['name'] 		= 	$filtr->filter($_POST['name']);
		$dane['email'] 		= 	$filtr->filter($_POST['email']);
		$dane['phone'] 		= 	$filtr->filter($_POST['phone']);
		$dane['desc'] 		= 	iconv('UTF-8','ISO-8859-2',$filtr->filter($_POST['desc']));

		$hash = md5($dane['name'].$dane['email'].$dane['phone'].$dane['desc']);


		
		if(isset($_SESSION['send_hash']) && $hash == $_SESSION['send_hash']){
			return 2;
		}

		if(empty($dane['name']) || $dane['name']=='Imię'){
			return 3;
		}
		
		if(empty($dane['email']) || $dane['email']=='email'){
			return 5;
		}
		
		if(empty($dane['phone']) || $dane['phone']=='telefon'){
			return 6;
		}
		
		if(empty($dane['desc']) || $dane['desc']=='treść zapytania'){
			return 7;
		}
		
		if(!$this->check_mail_syntax($dane['email'])){
			return 4;
		}
		
		
		else {
			$smarty = new Smarty;
			$smarty->compile_check = true;
			$smarty->debugging = false;
			$smarty->assign('dane',$dane);
			$body = $smarty->fetch('mail.tpl');

			$mail =	new Zend_Mail('utf-8');
			$mail->setBodyHtml($body);
			$mail->setFrom('Jubiler: '.$dane['email'], $dane['name']);
//			$mail->addTo('m.kaczmarek@bachanalia-wina.pl', 'Bachanalia');
			$mail->addTo('biuro@rleonardo.pl', 'Leonardo');
			$mail->setSubject('Leonardo: '.$dane['name']);
			if($mail->send()){
				$_SESSION['send_hash'] = $hash;
//				unset($_SESSION['koszyk']);
				return 1;
			}
		}
	}

	public function getContent()
	{
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');
		$id = 0;
		include_once 'kategorie/classKategorie.php';
		include_once 'tresc/classTresc.php';
//		include_once 'uslugi/classUslugi.php';
		include_once 'newsy/classAktualnosci.php';
//		include_once 'produkty/classProdukty.php';
		include_once 'gallery/classGalerie.php';
		$content = new Strony();
//		$usl = new Uslugi();
		$cat = new Kategorie();
		$news = new Aktualnosci();
//		$prod = new Produkty();
		$gal = new Galerie();
		$_SESSION['language'] = 'pl';


		if(isset($_POST['send'])){
			$tpl->assign('send_result',$this->send_question());
		}

		$tpl->assign('set',$this->getSettings());

		$tpl->assign('menu',$cat->getMenu(1));
		$fotos = $gal->getZdjeciaAll(5);
		if( !empty($fotos))
			$tpl->assign('pop',$fotos[0]['nazwa']);
		
//		echo '<pre>';print_r($cat->getMenu(1));die();
		if(!isset($_GET['strona'])){
			$tpl->assign('news',$news->getAllNews(4));
			$tpl->assign('contact',$content->getContent(6));
			$tpl->assign('content',$content->getContent(1));
			$tpl->assign('include',	'startowa.tpl');
		}


		
		if(isset($_GET['strona'])){
			if(isset($_GET['id']))
			$id 			=	(int)$_GET['id'];
			if(isset($_GET['strona']))
			$strona 		=	(int)$_GET['strona'];

			@$path = $cat->getPath($strona);
			@sort($path);
			@$tpl->assign('path',$path);
			
			if($path[0]['id']==5){
				$id=$strona;
				$strona=5;
			}
//			print_r($path);
			
			switch($strona){
				case 3:
//					print_r($news->getNews());die();
//					$tpl->assign('cat',$cat->getCat($id));
					if(!isset($id) || empty($id)){
					$news_main = $news->getWantedNews();
					$tpl->assign('news_main',$news_main);
					$tpl->assign('news_list',$news->getAllNews(0,$news_main['id']));}
					else{
					$tpl->assign('news_main',$news->getWantedNews($id));
					$tpl->assign('news_list',$news->getAllNews(0,$id));		
					}
					$tpl->assign('column','k-oferta.tpl');
					$tpl->assign('include','aktualnosci.tpl');
					break;
				case 5:
//					$tpl->assign('cat',$cat->getCat($id));
					$tpl->assign('content',$gal->getZdjeciaAll($id));
					$tpl->assign('include','galeria.tpl');
					break;
				case 6:
					$tpl->assign('content',$content->getContent($strona));
					$tpl->assign('include','kontakt.tpl');
					break;
				case 7:
					$tpl->assign('content',$content->getContent($strona));
					$tpl->assign('include','jakdojechac.tpl');
					break;
				default:
					$tpl->assign('content',$content->getContent($strona));
					$tpl->assign('include',	'tekstowa.tpl');
					
					break;
			}

		}
		//if( empty($_GET['q']) && $strona > 135)
			//$tpl->display('index.tpl');
		//else if ( !empty($_GET['q'])  || $strona < 137 )
		//{
			$tpl->display('index2.tpl');
		//}
			
	}

	function getSettings(){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		return $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."meta WHERE id = 1");

	}
	
	public static function toPermalink($string)
	{


		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/',
		'/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
		'/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
		'/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
		'/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
		'/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
		'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
		'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
		'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
		'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
		'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );

	}

	public static function pathToNode($id,$s='1')
	{
		$db = Zend_Registry::get('db');

		if(!empty($id))
		{
			$sql = "SELECT lleft, rright FROM cms_drzewko WHERE id=".(int)$id;
			$results = $db->fetchAll($sql);

			if(!empty($results))
			{
				$sql = "SELECT * FROM cms_drzewko WHERE lleft <=".$results[0]['lleft']." AND rright >=".$results[0]['rright']." ORDER BY id";
				$results = $db->fetchAll($sql);

				$countResults = count($results);

				$path = null;
				$tab = array();

				for($i=0;$i<$countResults;$i++)
				{
					if($results[$i]['id']==1) $path .= '';
					else if($results[$i]['parent_id']==1) $path .= '';

					else $tab[$i]= ucfirst($results[$i]['nazwa']);
				}

				$path = join(' / ',$tab);
			}
		}

		else $path ='';

		return $path;

	}
}
?>