<?
/*
 * Klasa do obsługi Promocji
 */
include_once './php/klasy/drzewko.php';
class Rabaty extends drzewko
{
	const tabela = 'promotion';
	const p = 14;
	
	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}

		return $result;
	}
	
	public function form($akcja= 'dodaj', $tab = null)
	{
		$modif = array();
		$modif[0]['id'] = 'm';
		$modif[0]['nazwa'] = 'minus - cena spadnie';
		$modif[1]['id'] = 'p';
		$modif[1]['nazwa'] = 'plus - cena wzrosnie';
		
		$new = new generatorFormularzy('Rabat','./index.php?p='.self::p.'&a=2','POST','enctype="multipart/form-data"',true);
		$new->poczatekForm();
		
		$new->inupt('Marka', 'text',!empty($tab['marka']) ? $tab['marka'] : '','','textlong');
		$new->inupt('Model', 'text',!empty($tab['model']) ? $tab['model'] : '','','textlong');
//		$new->inupt('Rozmiar', 'text',!empty($tab['rozmiar']) ? $tab['rozmiar'] : '','','textlong');
		$new->inupt('Sezon', 'text',!empty($tab['sezon']) ? $tab['sezon'] : '','','textlong');
		$new->inupt('Rodzaj', 'text',!empty($tab['rodzaj']) ? $tab['rodzaj'] : '','','textlong');
		$new->text('<br />');
		$new->select('kategoria', $this->displayTreeSelect(14), !empty($tab['kategoria']) ? $tab['kategoria'] : '', '', true, 'Wybierz kategorię');
		$new->text('<br />');
		$new->select('modyfikator', $modif, !empty($tab['modyfikator']) ? $tab['modyfikator'] : '', '', true, 'Wybierz rodzaj');
		$new->inupt('Rabat', 'text',!empty($tab['rabat']) ? $tab['rabat'] : '','','textlong');
		
//		$new->textarea('Opis', 20, 80,'',!empty($tab['opis']) ? stripslashes($tab['opis']) : '');

		$new->text('<br />');
		
		
	
		$new->text('<br />');

		$new->inupt('r', 'hidden',time(),'','',false);
		$new->inupt('akcja', 'hidden',$akcja,'','',false);

		if(isset($_GET['nr']))
		$new->inupt('id', 'hidden',$_GET['nr'],'','',false);

		$new->inupt('ok', 'submit',ucfirst($akcja),'','searchbutton',false);
		$new->text('<br />');
		$new->koniecForm();
	}


	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');

		$submenu[0]['link'] = '?p='.self::p.'&a=1';
		$submenu[0]['tekst'] = 'Dodaj nowy';
			
		$smarty->assign('submenu', $submenu);
		$smarty->assign('lista',$this->lista());
//		print_r($this->lista()); die();
	}
	
	public function add()
	{
		try
		{
			$smarty = Zend_Registry::get('smarty');

			Zend_Loader::loadClass('Zend_Filter_StripTags');
			$filtr = new Zend_Filter_StripTags();

			if(isset($_SESSION['form']) && $_SESSION['form']==$_POST['r'])
				throw new Exception('Nie odświeżaj strony!');

			$_SESSION['form'] = $_POST['r'];

			$data = array();
			
//			$data['nazwa'] 		= 	$filtr->filter($_POST['nazwa']);
			$data['marka'] 		= 	$filtr->filter($_POST['marka']);
			$data['model'] 		= 	$filtr->filter($_POST['model']);
//			$data['rozmiar'] 	= 	$filtr->filter($_POST['rozmiar']);
//			$data['cena'] 		= 	$filtr->filter($_POST['cena']);
			$data['sezon'] 		= 	$filtr->filter($_POST['sezon']);
			$data['rodzaj'] 	= 	$filtr->filter($_POST['rodzaj']);
//			$data['nosnosc'] 	= 	$filtr->filter($_POST['nosnosc']);
			$data['kategoria'] 	= 	$filtr->filter($_POST['kategoria']);
			$data['rabat'] 	= 	$filtr->filter($_POST['rabat']);
			$data['modyfikator'] 	= 	$filtr->filter($_POST['modyfikator']);
			
			if(empty($data['rabat']))
				throw new Exception('Nie dodano wielkości rabatu');
			else if(!eregi('^([0-9]{1,2})',$data['rabat']))
				throw new Exception('Wielkość rabatu wpisana niepoprawnie (poprawny zapis: 10)');
			
			if(empty($data['modyfikator']))
				throw new Exception('Nie wybrano modyfikatora (minus - cena bedzie mniejsza / plus - cena bedzie wyzsza)');
				
			if(empty($data['kategoria']))
				throw new Exception('Nie wybrano kategorii');	
				
			$id = $data['kategoria'];
			

				
			$db = Zend_Registry::get('db');

			if($_POST['akcja']=='dodaj')
			{
				$db->insert(Index::dbPrefiks.self::tabela, $data);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Dodano prawidłowo.'));
				$this->menu();
			}
			else
			{
				$db->update(Index::dbPrefiks.self::tabela,$data, 'id='.(int)$_POST['id']);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Dane zostały zmienione prawidłowo.'));
				$this->menu();
			}
		}
			
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public function lista()
	{
		try
		{
			$sql = "
			SELECT p.*,c.nazwa_pl as knazwa
			FROM ".Index::dbPrefiks."promotion p
			LEFT JOIN ".Index::dbPrefiks."drzewko c on p.kategoria = c.id
			ORDER BY p.id ASC";
			
			$db = Zend_Registry::get('db');

			return $db->fetchAll($sql);
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
			
		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}
	
	public function delete($id)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('Brak identyfikatora.');
			}
			
			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');
			$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where id='.(int)$id;
		
			$plik = $db->fetchRow($sql);
						
			$db->delete(Index::dbPrefiks.self::tabela,'id='.(int)$id);
					
			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> '<b>'.$plik['nazwa'].'</b> został poprawnie usuniety.'));
			$this->menu();
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
			
		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}
	
	public function edit()
	{
		try
		{
			if(!isset($_GET['nr']) || empty($_GET['nr']))
				throw new Exception('Blad przy edycji!');
				
			$sql="SELECT * FROM ".Index::dbPrefiks.self::tabela." WHERE id=".(int)$_GET['nr'];

			$db = Zend_Registry::get('db');
			$this->form('edycja',$db->fetchRow($sql));
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
}
?>