<?
/*
* Klasa do obsługi Produktów
*/
include_once './php/klasy/drzewko.php';
class Produkty extends drzewko
{
	const tabela = 'products';
	const p = 10;

	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}

		return $result;
	}

	public function form($akcja= 'dodaj', $tab = null)
	{
		$new = new generatorFormularzy('Produkt','./index.php?p='.self::p.'&a=2','POST','enctype="multipart/form-data"',true);
		$new->poczatekForm();

		$new->inupt('Nazwa', 'text',!empty($tab['nazwa']) ? $tab['nazwa'] : '','','textlong');
		$new->select('kategoria', $this->displayTreeSelect(54), !empty($tab['kategoria']) ? $tab['kategoria'] : '', '', true, 'Wybierz kategorię');
		$new->input('Zdjęcie', 'file', '', '', '', true);
		$new->textarea('Opis', 20, 80,'',!empty($tab['opis']) ? stripslashes($tab['opis']) : '');

		$new->inupt('r', 'hidden',time(),'','',false);
		$new->inupt('akcja', 'hidden',$akcja,'','',false);

		if(isset($_GET['nr']))
		$new->inupt('id', 'hidden',$_GET['nr'],'','',false);

		$new->inupt('ok', 'submit',ucfirst($akcja),'','searchbutton',false);
		$new->text('<br />');
		$new->koniecForm();
	}

	public function getProduct($id){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where id = '.(int)$id;
		return  $db->fetchRow($sql);
	}

	public function getUpperProduct($kolejnosc){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where kolejnosc < '.$kolejnosc.' ORDER BY kolejnosc DESC LIMIT 1';
		return  $db->fetchRow($sql);
	}

	public function getDownProduct($kolejnosc){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where kolejnosc > '.$kolejnosc.' ORDER BY kolejnosc ASC LIMIT 1';
		return  $db->fetchRow($sql);
	}

	public function  getLastProduct(){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where kolejnosc != 999 ORDER BY kolejnosc DESC limit 1';
		return  $db->fetchRow($sql);
	}
	
	public function updateKolejnosc($id,$kolejnosc){
		$db 	= 	Zend_Registry::get('db');
		$data['kolejnosc'] = $kolejnosc;
		$db->update(Index::dbPrefiks.self::tabela,$data, 'id='.$id);
	}

	public function goUp(){
		$smarty = 	Zend_Registry::get('smarty');
		$db 	= 	Zend_Registry::get('db');
		$id		=	(int)$_GET['nr'];

		$p 		=	$this->getProduct($id);

		switch($p['kolejnosc']){
			case 999:
				$i = $this->getLastProduct();
				$kolejnosc = (int)$i['kolejnosc']+1;
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
			case 1:
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Produkt jest już najwyżej !"));
				break;
			default:
				$kolejnosc = (int)$p['kolejnosc']-1;
				
				$i = $this->getUpperProduct($p['kolejnosc']);
				
				if($i['id'] > 0)
				$this->updateKolejnosc($i['id'],$p['kolejnosc']);
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
		}
		$this->menu();
	}
	
	public function goDown(){
		$smarty = 	Zend_Registry::get('smarty');
		$db 	= 	Zend_Registry::get('db');
		$id		=	(int)$_GET['nr'];

		$p 		=	$this->getProduct($id);

		$last	=	$this->getLastProduct();

		switch($p['kolejnosc']){
			case 999:
				$kolejnosc = (int)$last['kolejnosc']+1;
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
			case $last['kolejnosc']:
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Produkt jest już najniżej !"));
				break;
			default:
				$kolejnosc = (int)$p['kolejnosc']+1;
				
				$i = $this->getDownProduct($p['kolejnosc']);
				
				if($i['id'] > 0)
				$this->updateKolejnosc($i['id'],$p['kolejnosc']);
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
		}
		
		$this->menu();
	}

	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');

		$submenu[0]['link'] = '?p='.self::p.'&a=1';
		$submenu[0]['tekst'] = 'Dodaj nową';

		$smarty->assign('submenu', $submenu);
		$smarty->assign('lista',$this->lista());
	}

	public function add()
	{
		try
		{
			$smarty = Zend_Registry::get('smarty');

			Zend_Loader::loadClass('Zend_Filter_StripTags');
			$filtr = new Zend_Filter_StripTags();

			if(isset($_SESSION['form']) && $_SESSION['form']==$_POST['r'])
			throw new Exception('Nie odświeżaj strony!');

			$_SESSION['form'] = $_POST['r'];

			$data = array();

			$data['nazwa'] 		= 	$filtr->filter($_POST['nazwa']);
			$data['opis'] 		= 	$_POST['opis'];
			$data['kategoria'] 	= 	$filtr->filter($_POST['kategoria']);

//			echo $data['opis'];
//			echo '<br/><br/><br/>';
//			echo $_POST['opis'];
//			die();
			
			
			
			$id = $data['kategoria'];

			$tab = explode('.',$_FILES['zdjecie']['name']);
			if($tab[1]!='jpg' && $tab[1]!='jpeg' && $tab[1]!='JPG' && $tab[1]!='JPEG'){
				$error = array();
				$error['typ'] = 'error';
				$error['tekst'] = 'Błąd. Niewłaściwy format pliku. Wymagane pliki *.<strong>jpg</strong>. <a href="?p='.(int)$_GET['p'].'&a=6">Spróbuj ponownie</a>';
				$smarty->assign('komunikat',$error);

			}
			else{
				global $_FILES;
				$NazwaPliku = $_FILES['zdjecie']['name'];
				$RozmiarPliku = $_FILES['zdjecie']['size'];
				$TymczasowaNazwaPliku = $_FILES['zdjecie']['tmp_name'];
				$Blad = $_FILES['zdjecie']['error'];

				$nameOfFile = $NazwaPliku;
				$NazwaPliku = date('Ydmhis').Index::usun_ogonki(str_replace(" ", "_", $NazwaPliku));
				$katalog = '../galeria/';
				$katalog_min = '../galeria/min/';
				if(!is_dir($katalog))
				{
					mkdir($katalog);
					chmod($katalog,0777);
				}
				if(!is_dir($katalog_min))
				{
					mkdir($katalog_min);
					chmod($katalog_min,0777);
				}
				if(is_uploaded_file($TymczasowaNazwaPliku))
				{
					move_uploaded_file($TymczasowaNazwaPliku, $katalog.$NazwaPliku);
					$this->cropImage($katalog.$NazwaPliku, $katalog_min.$NazwaPliku,132,132);
					$data['zdjecie'] = $NazwaPliku;
				}
				else{
					$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd2: ".$katalog));
				}
			}

			$db = Zend_Registry::get('db');

			if($_POST['akcja']=='dodaj')
			{
				$i					=	$this->getLastProduct();
				$data['kolejnosc'] 	= 	$i['kolejnosc']+1;
				
				$db->insert(Index::dbPrefiks.self::tabela, $data);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Dodano prawidłowo.'));
				$this->menu();
			}
			else
			{
				$db->update(Index::dbPrefiks.self::tabela,$data, 'id='.(int)$_POST['id']);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Dane zostały zmienione prawidłowo.'));
				$this->menu();
			}
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function lista()
	{
		try
		{
			$sql = "
			SELECT p.*,c.nazwa_pl as knazwa
			FROM ".Index::dbPrefiks."products p
			LEFT JOIN ".Index::dbPrefiks."drzewko c on p.kategoria = c.id
			ORDER BY p.kolejnosc ASC";

			$db = Zend_Registry::get('db');

			return $db->fetchAll($sql);
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function delete()
	{
		try
		{
			$id = $_GET['nr'];
			
			if(empty($id))
			{
				throw new Exception('Brak identyfikatora.');
			}

			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');
			$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where id='.(int)$id;

			$plik = $db->fetchRow($sql);

			$db->delete(Index::dbPrefiks.self::tabela,'id='.(int)$id);

			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> '<b>'.$plik['nazwa'].'</b> został poprawnie usuniety.'));
			$this->menu();
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function edit()
	{
		try
		{
			if(!isset($_GET['nr']) || empty($_GET['nr']))
			throw new Exception('Blad przy edycji!');

			$sql="SELECT * FROM ".Index::dbPrefiks.self::tabela." WHERE id=".(int)$_GET['nr'];

			$db = Zend_Registry::get('db');
			$this->form('edycja',$db->fetchRow($sql));
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
}
?>