<?php 

/**
 * Klasa odpowiedzialna za obsluge obrazkow CMS
 * @author Bartosz Strzala - azureusnet.pl
 */


class galeria
{
	const p = 5;
	
	private $dir = null;
	private $width = null;
	private $height = null;
	
	
	public function __construct($dir, $height = 60, $width = 60) {
		$this->dir = $dir;
		$this->width = $width;
		$this->height = $height;
	}
	
	/**
	 * Funkcja generujaca porstokatne miniaturki
	 * @param $file
	 * @param $flaga
	 * @return void
	 */
	
	public function setThumb(array $file, $flaga) {
		include_once 'Asido/class.asido.php';
		
		asido::driver('gd');

		$thumb = asido::image($file['path'].$file['name'],$file['path'].'/min/200'.$file['name']);
		
		asido::height($thumb,$this->height);
		
		$thumb->save(ASIDO_OVERWRITE_ENABLED);
	}
	
	/**
	 * Funkcja generujaca kwadratowe miniaturki
	 * @todo przerobic parametry na takie jakie sa w poprzedniej funkcji
	 * @param $zdjecie
	 * @param $katalog
	 * @param $tmp_pliku
	 * @param $x
	 * @param $y
	 * @return unknown_type
	 */
	
	public function stworz_miniaturki($zdjecie,$katalog,$tmp_pliku,$x,$y) {
		
		$miniaturka = imagecreatefromjpeg($katalog.$zdjecie);
		list($ow, $oh) = getimagesize($tmp_pliku);
		$big = imagecreatefromjpeg($tmp_pliku);
		$thumb = imagecreatetruecolor($x,$y);
		$white = imagecolorallocate($thumb, 255, 255, 255);
		imagefilledrectangle($thumb, 0, 0, $x, $y, $white);
		
		$xskala=$ow/$x;
		$yskala=$oh/$y;
		
		if ($yskala<1 && $xskala<1)
		{
			$dis_w = round(($x-$ow)/2);
			$dis_h = round(($y-$oh)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $ow, $oh, $ow, $oh);
		}
		else
		{
			$ramka_w=$x;
			$ramka_h=$y;	
			if ($yskala>$xskala)
			{
				$x = round($ow * (1/$yskala));
				$y = round($oh * (1/$yskala));
			}
			else 
			{
				$x = round($ow * (1/$xskala));
				$y = round($oh * (1/$xskala));
			}	
			
			$dis_w = round(($ramka_w-$x)/2);
			$dis_h = round(($ramka_h-$y)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $x, $y, $ow, $oh);
		}
		
		imagejpeg($thumb, $katalog.'min/'.$zdjecie, 100);
	}
	
	public function form() {
		if(isset($_GET['id_s']))$id_s = (int)$_GET['id_s'];
		if(isset($_GET['nr']))$id = (int)$_GET['nr'];
			
		$new = new generatorFormularzy('Galeria','?p=5&a=1&co='.$_GET['co'].'&id='.$_GET['id'].'&kategoria='.$_GET['kategoria'].'&frame', 'POST', 'enctype="multipart/form-data"');
		$new->poczatekForm();
		$new->input('Zdjęcie', 'file', '', '', '', true);
		$new->text('<br />');
		$new->input('submit', 'submit', 'Dodaj plik', '', 'searchbutton', false);
		$new->input('r', 'hidden', time(), '', '', false);
		$new->input('co', 'hidden', $_GET['co'], '', '', false);
		$new->input('id', 'hidden', $_GET['id'], '', '', false);
		$new->koniecForm();		
	}
	
	public function add() {
		$smarty = Zend_Registry::get('smarty');

		$tab = explode('.',$_FILES['zdjecie']['name']);
		
		if($tab[1]!='jpg' && $tab[1]!='jpeg' && $tab[1]!='JPG' && $tab[1]!='JPEG')
		{
			$error = array();
			$error['typ'] = 'error';
			$error['tekst'] = 'Błąd. Niewłaściwy format pliku. Wymagane pliki *.<strong>jpg</strong>. <a href="?p='.(int)$_GET['p'].'&a=6">Spróbuj ponownie</a>';
			$smarty->assign('komunikat',$error);
		}
			
		else
		{
			if(isset($_SESSION['form']) && $_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
			$_SESSION['form'] = $_POST['r'];
				
			$id = $_POST['id'];
				
			global $_FILES;

			$NazwaPliku = $_FILES['zdjecie']['name'];
			$RozmiarPliku = $_FILES['zdjecie']['size'];
			$TymczasowaNazwaPliku = $_FILES['zdjecie']['tmp_name'];
			$Blad = $_FILES['zdjecie']['error'];
				
			$nameOfFile = $NazwaPliku;
			$NazwaPliku = md5(date('Ydmhis').$id).'.'.end($tab);
			$katalog = $this->dir;
			$katalog_min = $katalog.'min/';

			if(!is_dir($katalog_min))
			{
				mkdir($katalog_min);
				chmod($katalog_min,0777);
			}
				
			if(is_uploaded_file($TymczasowaNazwaPliku))
			{
				if(move_uploaded_file($TymczasowaNazwaPliku, $katalog.$NazwaPliku))
				{
					chmod($katalog.$NazwaPliku,0755);
					
					//$this->setThumb(array('name'=> $NazwaPliku,'path'=>$katalog),0);
					$this->stworz_miniaturki($NazwaPliku,$katalog,$katalog.$NazwaPliku,$this->width,$this->height);
					
					
					$dane['kategoria'] = $id;
					$dane['nazwa'] = $NazwaPliku;
					$dane['nazwa_prawdziwa'] = $nameOfFile;
					$dane['path'] = $this->dir;
					$dane['co'] = $_POST['co'];
					
					$db = Zend_Registry::get('db');
						
					$db->insert(Index::dbPrefiks.'obrazki',$dane);
					
					$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$dane['nazwa_prawdziwa'].'</b> został poprawnie dodany.'));
					$result = true;
				}

				else
				{
					$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd1: ".$Blad));
				}
			}

			else
			{
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd2: ".$katalog));
			}

			$this->menu();
			return $result;
		}		
	}
	
	public function lista()
	{
		try
		{
			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');

			$sql="SELECT * FROM ".Index::dbPrefiks."obrazki WHERE co='".$_GET['co']."' AND kategoria=".$_GET['id'];
			$result = $db->fetchAll($sql);
			
			if(count($result) <= 50) {
				$smarty->assign('submenu', array(0 => array('link' => '?p='.self::p.'&a=2&co='.$_GET['co'].'&kategoria='.$_GET['kategoria'].'&id='.$_GET['id'].'&frame', 'tekst' => 'Dodaj nowe zdjęcie')));
			}
			
			$smarty->assign('lista', $result);
			
		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public function delete()
	{
		$db = Zend_Registry::get('db');
		$smarty = Zend_Registry::get('smarty');	
	
		$sql="SELECT * FROM ".Index::dbPrefiks."obrazki WHERE co='".$_GET['co']."' AND kategoria=".$_GET['id'];
		$result = $db->fetchAll($sql);
		
		$db->delete(Index::dbPrefiks.'obrazki', 'id='.$_GET['id']);
		
		@ulink('..'.$result[0]['path'].'/'.$result[0]['nazwa_prawdziwa']);
		
		$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik został poprawnie usunięty.'));
	}
	
	public function menu()
	{
		$this->lista();
	}
}
?>