<?php

/*
 * Klasa odpowiadająca za upload plików
 */

include_once './php/klasy/drzewko.php';
class File extends drzewko
{
	private $_tab = array();
	private $_katalog;
	private $_table = 'files';

	const PAGE = 12;
	const DIR = '../files';

	public function settings($katalog = null, $rozszerzenie = null)
	{
		try
		{
			/*
			 * Ustalamy dopuszczone rozszerzenia
			 */

			if(!empty($rozszerzenie))
			{
				$this->_tab[0] = $rozszerzenie;
			}

			/*
			 * Tworzenie katalogu i ustawianie praw
			 */

			if(!empty($katalog))
			{
				$this->_katalog = self::DIR.'/'.$katalog;

				if(!is_dir($this->_katalog))
				{
					mkdir($this->_katalog);
					chmod($this->_katalog,0777);
						
				}
			}
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function form()
	{

		$new = new generatorFormularzy('Pliki','?p='. self::PAGE .'&a=3', 'POST', 'enctype="multipart/form-data"');
		$new->poczatekForm();
		
		$new->inupt('Tytul', 'text',!empty($tab['title']) ? $tab['title'] : '','','textlong');
	//	$new->select('kategoria', $this->displayTreeSelect(), '', '', true, 'Wybierz kategorię');
		$new->select('Produkt', $this->produkty(), '', '', true, 'Wybierz produkt');
		$new->input('Plik', 'file', '', '', '', true);
		$new->text('<br>');
		$new->input('submit', 'submit', 'Dodaj plik', '', 'searchbutton', false);
		$new->input('r', 'hidden', time(), '', '', false);
		$new->koniecForm();
	}

	/*
	 * File upload function
	 */
	
	public function getFile($id){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.$this->_table.' where id = '.(int)$id;
		return  $db->fetchRow($sql);
	}

	public function getUpper($kolejnosc){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.$this->_table.' where kolejnosc < '.$kolejnosc.' ORDER BY kolejnosc DESC LIMIT 1';
		return  $db->fetchRow($sql);
	}

	public function getDown($kolejnosc){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.$this->_table.' where kolejnosc > '.$kolejnosc.' ORDER BY kolejnosc ASC LIMIT 1';
		return  $db->fetchRow($sql);
	}

	public function  getLast(){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.$this->_table.' where kolejnosc != 999 ORDER BY kolejnosc DESC limit 1';
		return  $db->fetchRow($sql);
	}
	
	public function updateKolejnosc($id,$kolejnosc){
		$db 	= 	Zend_Registry::get('db');
		$data['kolejnosc'] = $kolejnosc;
		$db->update(Index::dbPrefiks.$this->_table,$data, 'id='.$id);
	}

	public function goUp(){
		$smarty = 	Zend_Registry::get('smarty');
		$db 	= 	Zend_Registry::get('db');
		$id		=	(int)$_GET['nr'];

		$p 		=	$this->getFile($id);
		
		switch($p['kolejnosc']){
			case 999:
				$i = $this->getLast();
				$kolejnosc = (int)$i['kolejnosc']+1;
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
			case 1:
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Produkt jest już najwyżej !"));
				break;
			default:
				$kolejnosc = (int)$p['kolejnosc']-1;
				
				$i = $this->getUpper($p['kolejnosc']);
				
				if($i['id'] > 0)
				$this->updateKolejnosc($i['id'],$p['kolejnosc']);
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
		}
		$this->menu();
	}
	
	public function goDown(){
		$smarty = 	Zend_Registry::get('smarty');
		$db 	= 	Zend_Registry::get('db');
		$id		=	(int)$_GET['nr'];

		$p 		=	$this->getFile($id);

		$last	=	$this->getLast();

		switch($p['kolejnosc']){
			case 999:
				$kolejnosc = (int)$last['kolejnosc']+1;
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
			case $last['kolejnosc']:
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Produkt jest już najniżej !"));
				break;
			default:
				$kolejnosc = (int)$p['kolejnosc']+1;
				
				$i = $this->getDown($p['kolejnosc']);
				
				if($i['id'] > 0)
				$this->updateKolejnosc($i['id'],$p['kolejnosc']);
				
				$this->updateKolejnosc($id,$kolejnosc);
				
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> "Kolejność została zmieniona !"));
				break;
		}
		
		$this->menu();
	}
	
	public function add()
	{
		try
		{
			global $_FILES;
			$smarty = Zend_Registry::get('smarty');
				
			$errors = array('1'=>'The file is bigger than this PHP installation allows',
							'2'=>'The file is bigger than this form allows',
							'3'=>'Only part of the file was uploaded',
							'4'=>'No file was uploaded');
				
			$this->valid($_FILES['plik']['name']);

			$nameOfFile = date('Ydmhis').Index::usun_ogonki(str_replace(" ", "_", $_FILES['plik']['name']));
				
			if(is_uploaded_file($_FILES['plik']['tmp_name']))
			{
				if(move_uploaded_file($_FILES['plik']['tmp_name'], $this->_katalog.'/'.$nameOfFile))
				{
					chmod($this->_katalog.'/'.$nameOfFile,0755);
						
					$dane['title'] = $_POST['tytul'];
					$dane['product'] = (int)$_POST['produkt'];
					$dane['name'] = $nameOfFile;
					$dane['true_name'] = $_FILES['plik']['name'];
					
					$db = Zend_Registry::get('db');

					$db->insert(Index::dbPrefiks.$this->_table, $dane);
						
					$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$dane['true_name'].'</b> został poprawnie dodany.'));
					$this->menu();
				}

				else
				{
					$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd: ".$_FILES['plik']['name']));
				}
			}

			else
			{
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd: ".$errors[$_FILES['plik']['error']]));
			}
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
			
		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}

	/*
	 * File delete functions
	 */

	public function delete($id)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('Brak identyfikatora pliku.');
			}
				
			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');
				
			$sql = 'select name, true_name from '.Index::dbPrefiks.$this->_table.' WHERE id='.(int)$id;
			$plik = $db->fetchRow($sql);
				
			$db->delete(Index::dbPrefiks.$this->_table,'id='.(int)$id);
			unlink($this->_katalog.'/'.$plik['name']);
				
			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$plik['true_name'].'</b> został poprawnie usuniety.'));
			$this->menu();
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function listOfFiles()
	{
		try
		{
			
			$sql = '
			select f.*,p.nazwa as prod_nazwa
			from '.Index::dbPrefiks.$this->_table.' f 
			left join '.Index::dbPrefiks.'products p on f.product = p.id
			ORDER BY f.kolejnosc asc';
				
			$db = Zend_Registry::get('db');
				
			return $db->fetchAll($sql);
		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	/*
	 * Valid function
	 */

	public function valid($fileName)
	{
		try
		{
			$file = explode('.',$fileName);

			if(!in_array(strtolower($file[1]), $this->_tab))
			{
				throw new Exception('Nie prawidłowy format pliku.');
			}
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');
		$smarty->assign('submenu', array(0 => array('link' => '?p='. self::PAGE .'&a=2', 'tekst' => 'Dodaj nowy plik')));
		$smarty->assign('lista',$this->listOfFiles());
	}

	public static function getListOfFiles()
	{
		$sql = 'select f.id id, concat(d.nazwa,"=>"f.true_name) nazwa from '.Index::dbPrefiks.$this->_table.' f join '.Index::dbPrefiks.'drzewko d on f.kategoria=d.id ORDER BY name';

		$db = Zend_Registry::get('db');

		return $db->fetchAll($sql);
	}

	public function produkty() {
		$sql = "select id, nazwa from " .Index::dbPrefiks."products ORDER BY nazwa";
			
		$db = Zend_Registry::get('db');
			
		return $db->fetchAll($sql);
	}
}
?>