<?php

require_once'./php/klasy/drzewko.php';

class galerie extends drzewko
{
	const MIN = 112;
	private $height = 150;
	private $kat_id = 45;

	public function setThumb(array $file, $flaga)
	{
		include_once 'Asido/class.asido.php';

		asido::driver('gd');

		$thumb = asido::image($file['path'].$file['name'],$file['path'].'/min/200'.$file['name']);

		asido::height($thumb,$this->height);

		$thumb->save(ASIDO_OVERWRITE_ENABLED);
	}

	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}

		return $result;
	}

function cropImage2($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);
		
		$white= imagecolorallocate($dimg, 86, 38, 28);
		imagefill($dimg, 0, 0, $white);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
//			$adjusted_width = $w / $hm;
//			$half_width = $adjusted_width / 2;
//			$int_width = $half_width - $w_height;
//			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

			

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}

		return $result;
	}
	
	public function stworz_miniaturki($zdjecie,$katalog,$tmp_pliku,$x,$y)
	{
		$miniaturka = imagecreatefromjpeg($katalog.$zdjecie);
		list($ow, $oh) = getimagesize($tmp_pliku);
		$big = imagecreatefromjpeg($tmp_pliku);
		$thumb = imagecreatetruecolor($x,$y);
		$white = imagecolorallocate($thumb, 255, 255, 255);
		imagefilledrectangle($thumb, 0, 0, $x, $y, $white);

		$xskala=$ow/$x;
		$yskala=$oh/$y;

		if ($yskala<1 && $xskala<1)
		{
			$dis_w = round(($x-$ow)/2);
			$dis_h = round(($y-$oh)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $ow, $oh, $ow, $oh);
		}
		else
		{
			$ramka_w=$x;
			$ramka_h=$y;
			if ($yskala>$xskala)
			{
				$x = round($ow * (1/$yskala));
				$y = round($oh * (1/$yskala));
			}
			else
			{
				$x = round($ow * (1/$xskala));
				$y = round($oh * (1/$xskala));
			}

			$dis_w = round(($ramka_w-$x)/2);
			$dis_h = round(($ramka_h-$y)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $x, $y, $ow, $oh);
		}
		imagejpeg($thumb, $katalog.'min/200'.$zdjecie, 100);
	}

	
	public function displayTreeSelectStrony($s='')
	{

		try
		{
			$db = Zend_Registry::get('db');

			if(!empty($s))$sql = "SELECT *,tytul as nazwa FROM ".Index::dbPrefiks."art WHERE id=".(int)$s;
			else $sql = "SELECT *,tytul as nazwa FROM ".Index::dbPrefiks."art WHERE id>3 ORDER BY id";

			$results = $db->fetchAll($sql);
			if(!empty($results))
			{
//				$sql_select = "SELECT *,nazwa_pl as nazwa FROM ".Index::dbPrefiks."drzewko WHERE lleft BETWEEN '".$results[0]['lleft']."' AND '".$results[0]['rright']."' ORDER BY lleft;";
//				
////				echo $sql_select ; die();
//				$results = $db->fetchAll($sql_select);
				$countResults = count($results);
//				$right = array();

				for($i=0;$i<$countResults;$i++)
				{
//					if(count($right) > 0)
//					{
//						while($right[count($right)-1] < $results[$i]['rright'])
//						{
//							array_pop($right);
//						}
//					}

					$lista[$i]['id'] = $results[$i]['id'];
					$lista[$i]['nazwa'] = str_repeat(' » ',count($right));

//					if($results[$i]['id'] == $s) $lista[$i]['selected'] = true;
					/*if(count($right) - 1 > 0)
					{
					$select .= str_repeat('',count($right) - 1).''.$results[$i]['nazwa'];
					}

					else
					{
					$select .= ''.$results[$i]['nazwa'];
					}*/
					$lista[$i]['nazwa'] .= ''.$results[$i]['nazwa'];
//					$right[] = $results[$i]['rright'];
				}
			}

			if(!empty($lista)) {
				return $lista;
			}
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			przechwyc_blad($e);
		}
	}/* end displayTree(); */
	
	
	
	public function dodaj_plikAkcja()
	{
		$smarty = Zend_Registry::get('smarty');
		$db = Zend_Registry::get('db');
		
		$tab = explode('.',$_FILES['zdjecie']['name']);

		if(isset($_SESSION['form']) && $_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
		$_SESSION['form'] = $_POST['r'];

		if(isset($_POST['kategoria'])){
			$id = $_POST['kategoria'];
		}
		else {
			$id = $this->kat_id;
		}

		global $_FILES;

		$NazwaPliku = $_FILES['zdjecie']['name'];
		$RozmiarPliku = $_FILES['zdjecie']['size'];
		$TymczasowaNazwaPliku = $_FILES['zdjecie']['tmp_name'];
		$Blad = $_FILES['zdjecie']['error'];

		$filtr = new Zend_Filter_StripTags();

		if(is_uploaded_file($TymczasowaNazwaPliku))
		{
			$tab[1] = strtolower($tab[1]);

			if($tab[1]!='jpg' && $tab[1]!='jpeg' && $tab[1]!='gif' && $tab[1]!='png')
			{
				$error = array();
				$error['typ'] = 'error';
				$error['tekst'] = 'Błąd. Niewłaściwy format pliku. Wymagane pliki *.<strong>jpg</strong>. <a href="?p='.(int)$_GET['p'].'&a=6">Spróbuj ponownie</a>';
				$smarty->assign('komunikat',$error);
			}

			else
			{

				$nameOfFile = $NazwaPliku;
				$NazwaPliku = date('Ydmhis').Index::usun_ogonki(str_replace(" ", "_", $NazwaPliku));
				$katalog = '../galeria/';
				$katalog_min = $katalog.'min/';

				if(!is_dir($katalog))
				{
					mkdir($katalog);
					chmod($katalog,0777);
				}
				if(!is_dir($katalog_min))
				{
					mkdir($katalog_min);
					chmod($katalog_min,0777);
				}


				if(move_uploaded_file($TymczasowaNazwaPliku, $katalog.$NazwaPliku))
				{
					chmod($katalog.$NazwaPliku,0755);

					
						$this->cropImage2($katalog.$NazwaPliku, $katalog_min.$NazwaPliku,150,150);
					


					$file['name'] = $NazwaPliku;
					$file['path'] = $katalog;

					$dane['nazwa'] = $NazwaPliku;
					$dane['nazwa_prawdziwa'] = $nameOfFile;

				}

				else
				{
					$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd1: ".$Blad));
				}
			}

		}



		$dane['kategoria'] = $id;
		$dane['link'] = $filtr->filter($_POST['link']);
//		$dane['tytul'] = $filtr->filter($_POST['nazwa']);
//		$dane['masa'] = $filtr->filter($_POST['masa']);
//		$dane['galerie_cat'] = $filtr->filter($_POST['realizacje']);
		
		$sql = 'SELECT kolejnosc,id FROM '.Index::dbPrefiks.'galerie  WHERE kategoria='.$id.' ORDER BY kolejnosc DESC';
		$kol = $db->fetchRow($sql);
		
		$dane['kolejnosc'] =$kol['kolejnosc']+1;
		
		
		if((int)$_POST['id'] == 0){
			$db->insert(Index::dbPrefiks.'galerie',$dane);
			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$dane['nazwa_prawdziwa'].'</b> został poprawnie dodany.'));
		}
		else {
			$db->update(Index::dbPrefiks.'galerie',$dane,'id='.(int)$_POST['id']);
			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$dane['nazwa_prawdziwa'].'</b> został poprawnie zmieniony.'));
		}

		$result = true;

		$this->menu();
	}

	public function displayTreeSelectRealizacje($s='')
	{

		try
		{
			$db = Zend_Registry::get('db');

			if(!empty($s))$sql = "SELECT *,nazwa FROM ".Index::dbPrefiks."galerie_cat WHERE id=".(int)$s;
			else $sql = "SELECT *,nazwa FROM ".Index::dbPrefiks."galerie_cat";

			$results = $db->fetchAll($sql);
			if(!empty($results))
			{
//				$sql_select = "SELECT *,nazwa FROM ".Index::dbPrefiks."galerie_cat WHERE lleft BETWEEN '".$results[0]['lleft']."' AND '".$results[0]['rright']."' ORDER BY lleft;";
//				$results = $db->fetchAll($sql_select);
				$countResults = count($results);
//				$right = array();
//
				for($i=0;$i<$countResults;$i++)
				{
//					if(count($right) > 0)
//					{
//						while($right[count($right)-1] < $results[$i]['rright'])
//						{
//							array_pop($right);
//						}
//					}
//
					$lista[$i]['id'] = $results[$i]['id'];
					$lista[$i]['nazwa'] = $results[$i]['nazwa'];
//
//					if($results[$i]['id'] == $s) $lista[$i]['selected'] = true;
//					/*if(count($right) - 1 > 0)
//					{
//					$select .= str_repeat('',count($right) - 1).''.$results[$i]['nazwa'];
//					}
//
//					else
//					{
//					$select .= ''.$results[$i]['nazwa'];
//					}*/
//					$lista[$i]['nazwa'] .= ''.$results[$i]['nazwa'];
//					$right[] = $results[$i]['rright'];
				}
			}

			if(!empty($lista)) {
				return $lista;
			}
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			przechwyc_blad($e);
		}
	}/* end displayTree(); */
	
	public function getKategoria()
	{
		$db = Zend_Registry::get('db');

		$sql ='SELECT id, nazwa FROM '.Index::dbPrefiks.'drzewko';
		$results = $db->fetchAll($sql);

		return $results;
	}

	public function dodaj_plikForm($tab = array())
	{

		$new = new generatorFormularzy('Galeria','?p='.$_GET['p'].'&a=5', 'POST', 'enctype="multipart/form-data"');
		$new->poczatekForm();
		$new->input('Zdjęcie', 'file', '', '', '', true);
//		$new->inupt('Nazwa', 'text',!empty($tab['tytul']) ? $tab['tytul'] : '','','textlong');
//		$new->inupt('Masa', 'text',!empty($tab['masa']) ? $tab['masa'] : '','','textlong');
		$new->select('Kategoria', $this->displayTreeSelect(5), !empty($tab['kategoria']) ? $tab['kategoria'] : '', '', true, 'Wybierz kategorię');
//		$new->select('Realizacje', $this->displayTreeSelectRealizacje(), !empty($tab['galerie_cat']) ? $tab['galerie_cat'] : '', '', true, 'Wybierz kategorię');
		$new->text('<br>');

		$new->input('submit', 'submit', (int)$tab['id'] == 0 ? 'Dodaj plik' : 'Edytuj plik', '', 'searchbutton', false);
		$new->input('r', 'hidden', time(), '', '', false);
		$new->input('id', 'hidden', (int)$tab['id'], '', '', false);
		$new->koniecForm();

	}

	public function listaAdmin()
	{
		try
		{
			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');

			$sql="
			SELECT g.id,g.kolejnosc,g.kategoria,g.nazwa,g.nazwa_prawdziwa,a.id as kat_id,a.nazwa_pl as kat_nazwa
			FROM ".Index::dbPrefiks."galerie g
			LEFT JOIN ".Index::dbPrefiks."drzewko a on g.kategoria = a.id
			ORDER BY g.kategoria,g.kolejnosc
			";

			$result = $db->fetchAll($sql);
			$smarty->assign('lista', $result);
			$smarty->assign('MIN',self::MIN);
		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	/*
	* Funkcja usuwajaca informacje z bazy o zdjęciu oraz usuwiająca fizycznie plik z katalogu;
	*/

	public function usunObrazek($id,$nazwa)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select * from '.Index::dbPrefiks.'galerie where id='.$id;
		$g = $db->fetchRow($sql);

		$db->delete(Index::dbPrefiks.'galerie', 'id='.$id);
		$smarty = Zend_Registry::get('smarty');
		@unlink('../galeria/'.$g['kategoria'].'/min/200'.$nazwa);
		@unlink('../galeria/'.$g['kategoria'].'/'.$nazwa);

		$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik został poprawnie usunięty.'));

		//$this->menu();
	}

	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');
		$smarty->assign('submenu', array(0 => array('link' => '?p='.$_GET['p'].'&a=6', 'tekst' => 'Dodaj nowe zdjęcie do galerii')));
		$this->listaAdmin();
	}

	public function editOpisForm()
	{
		$db = Zend_Registry::get('db');
		$smarty = Zend_Registry::get('smarty');

		if(empty($_POST))
		{
			$sql = 'select opis, tytulowe from '.Index::dbPrefiks.'realizacje where id='.(int)$_GET['nr'];
			$opis = $db->fetchRow($sql);

			$new = new generatorFormularzy('Galeria','?p='.$_GET['p'].'&a=7', 'POST');
			$new->poczatekForm();

			$new->checkbox('Tytułowe', !empty($opis['tytulowe']) ? $opis['tytulowe'] : '');
			$new->input('submit', 'submit', 'Zapisz', '', 'searchbutton', false);
			$new->input('r', 'hidden', time(), '', '', false);
			$new->input('idd', 'hidden', (int)$_GET['nr'], '', '', false);
			$new->koniecForm();

		}
		else
		{
			$filtr = new Zend_Filter_StripTags();

			$dane = array();
			//	$dane['opis'] = $filtr->filter($_POST['opis']);

			if(isset($_POST['tytulowe']))
			$dane['tytulowe'] = $_POST['tytulowe'] == 'on' ? 1 : 0;
			else $dane['tytulowe'] = 0;

			$db->update(Index::dbPrefiks.'realizacje',$dane,'id='.(int)$_POST['idd']);
			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=>'<div class="kom">Opis został zmieniony prawidłowo.</div>'));
			$this->menu();
		}
	}

	public function zamienObrazek()
	{
		$id = (int)$_GET['nr'];

		$sql = "SELECT * FROM ".Index::dbPrefiks."galerie WHERE id=".$id;
		$db = Zend_Registry::get('db');

		$results = $db->fetchRow($sql);

		$this->dodaj_plikForm($results);
	}

	public static function getListOfImage($menu_id = null)
	{
		$sql = 'select id, nazwa_prawdziwa nazwa from '.Index::dbPrefiks.'realizacje WHERE kategoria='.(int)$menu_id;

		$db = Zend_Registry::get('db');

		return $db->fetchAll($sql);
	}

	public static function getImage($id)
	{
		$sql = 'select * from '.Index::dbPrefiks.'realizacje WHERE id='.(int)$id;

		$db = Zend_Registry::get('db');

		return $db->fetchRow($sql);
	}
	
	public function getUpper($kolejnosc,$kategoria){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.'galerie where kolejnosc < '.$kolejnosc.' and kategoria = '.$kategoria.' ORDER BY kolejnosc DESC LIMIT 1';
		return  $db->fetchRow($sql);
	}

	public function getDown($kolejnosc,$kategoria){
		$db 	= 	Zend_Registry::get('db');
		$sql = 'select * from '.Index::dbPrefiks.'galerie where kolejnosc > '.$kolejnosc.' and kategoria = '.$kategoria.' ORDER BY kolejnosc ASC LIMIT 1';
		return  $db->fetchRow($sql);
	}
	
	public function up()
	{
		$db = Zend_Registry::get('db');
		$smarty = Zend_Registry::get('smarty');

		$id = (int)$_GET['nr'];
		$kolejnosc = (int)$_GET['k'];
		$kategoria = (int)$_GET['c'];

		$sql = 'SELECT kolejnosc,id FROM '.Index::dbPrefiks.'galerie WHERE kategoria='.$kategoria.' ORDER BY kolejnosc ASC';
		$result = $db->fetchAll($sql);
		
		if($result[0]['kolejnosc'] != $kolejnosc)
		{
		
			$upper = $this->getUpper($kolejnosc,$kategoria);
			
			$data['kolejnosc'] = $upper['kolejnosc'];
			$data2['kolejnosc'] = $upper['kolejnosc']+1;
			
			
			$db->update(Index::dbPrefiks.'galerie',$data, 'id='.$id);
			$db->update(Index::dbPrefiks.'galerie',$data2, 'id='.$upper['id']);
		
		}
		else $smarty->assign('komunikat',array('typ'=>'error', 'tekst'=>'Niedozwolona czynność.'));

		$this->menu();
	}

	public function down()
	{
		$db = Zend_Registry::get('db');

		$id = (int)$_GET['nr'];
		$kolejnosc = (int)$_GET['k'];
		$kategoria = (int)$_GET['c'];
		
		$sql = 'SELECT kolejnosc,id FROM '.Index::dbPrefiks.'galerie  WHERE kategoria='.$kategoria.' ORDER BY kolejnosc DESC';
		$result = $db->fetchAll($sql);


		if($result[0]['kolejnosc'] != $kolejnosc)
		{
			$down = $this->getDown($kolejnosc,$kategoria);
			
			$data['kolejnosc'] = $down['kolejnosc'];
			$data2['kolejnosc'] = $down['kolejnosc']-1;
			
			
			$db->update(Index::dbPrefiks.'galerie',$data, 'id='.$id);
			$db->update(Index::dbPrefiks.'galerie',$data2, 'id='.$down['id']);
		}
		else {
			$smarty = Zend_Registry::get('smarty');
			$smarty->assign('komunikat',array('typ'=>'error', 'tekst'=>'Niedozwolona czynność.'));
		}
		$this->menu();
	}
	
}

?>